{include file="left.tpl"}

<script>
	jQuery(document).ready(function($)
	{
		load_open_tickets();
	});

	function load_open_tickets()
	{
		$.ajax({
			type: 'POST',
			url: '../templates/SquareLine/php/tickets.php',
			data: 'token='+$('#token').val(),
			success: function(data)
			{
				if(data.indexOf('<td') != -1)
					$('#tickets thead').show();

				$('#tickets .header span').html('открытых');
				$('#tickets thead tr th:nth-child(3)').html('Открыл');
				$('#tickets tbody').html(data);

				if(data.indexOf('<td') == -1)
					$('#tickets tbody > div').addClass('m-l-5 m-b-5 m-r-5 m-t-5');
			}
		});
	}

	function load_close_tickets(start)
	{
		$.ajax({
			type: 'POST',
			url: '../templates/SquareLine/php/tickets.php',
			data: 'token='+$('#token').val()+'&status=close&start='+start,
			success: function(data)
			{
				if(start == 0)
				{
					if(data.indexOf('<td') != -1)
						$('#tickets thead').show();

					$('#tickets .header span').html('закрытых');
					$('#tickets thead tr th:nth-child(3)').html('Закрыл');
					$('#tickets tbody').html(data);

					if(data.indexOf('<td') == -1)
						$('#tickets tbody > div').addClass('m-l-5 m-b-5 m-r-5 m-t-5');
				}else
					$('#tickets tbody').append(data);
			}
		});
	}
</script>

<div class="content float-right">
	<a class="button-big float-left" href="#" onclick="load_close_tickets('0'); return false"><i class="fa fa-ticket"></i> Закрытые тикеты ({count2})</a>
	<a class="button-big active float-right" href="#" onclick="load_open_tickets(); return false"><i class="fa fa-ticket"></i> Открытые тикеты ({count1})</a>

	<div class="clear"></div>

	<div class="block" id="tickets">
		<div class="header">Список <span>открытых</span> тикетов</div>
		<table class="table-list">
			<thead class="disp-n">
				<tr>
					<th align="right" width="1%">#</th>
					<th align="left" width="25%">Тема</th>
					<th align="left" width="15%">Открыл</th>
					<th align="right" width="25%">Последний ответ</th>
					<th align="right" width="25%">Дата</th>
				</tr>
			</thead>
			<tbody></tbody>
		</table>
	</div>
</div>